<?php
/**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */
require_once __DIR__ . '/../../config/config.inc.php';
require_once __DIR__ . '/hipercalzado.php';

$module = new Hipercalzado();

if (substr(Tools::hash('hipercalzado/index'), 0, 10) != Tools::getValue('token') || !Module::isInstalled('hipercalzado')) {
    exit('Bad token');
}

if (!Tools::getValue('id_shop')) {
    Context::getContext()->shop->setContext(Shop::CONTEXT_ALL);
} else {
    Context::getContext()->shop->setContext(Shop::CONTEXT_SHOP, (int) Tools::getValue('id_shop'));
}

// Anyadimos la moneda al contecto
$currencies_by_shop = HipercalzadoUtils::getCurrenciesByShop(Context::getContext()->shop->id);

if(empty($currencies_by_shop)) {
    die($module->l("Currencies not available"));
} else {
    // Seleccionamo la moneda por defecto 
    Context::getContext()->currency = new Currency($currencies_by_shop[0]);
}

Context::getContext()->employee = new Employee($module->configuration->id_employee);

HipercalzadoUtils::getOrders($module, true);

die("FIN");
