<?php
/**
 * 2022 4webs PrestaPOS
 *
 * DEVELOPED by 4webs.es Prestashop Superhero Partner
 *
 * @author    4webs
 * @copyright 4webs 2022
 * @license   4webs
 * @category administration-featureFront
 */

class HipercalzadoOrderProduct extends ObjectModel
{
    public $id_hipercalzado_order;
    public $hc_id_product;
    public $st_id_product;
    public $st_id_product_attribute;
    public $st_id_order_detail;
    public $hc_product_sku;
    public $quantity;
    public $can_refund;
    public $refunded;
    public $date_add;
    
    public static $definition = array(
        'table' => 'hipercalzado_order_product',
        'primary' => 'id_hipercalzado_order_product',
        'fields' => array(
            'id_hipercalzado_order' => array('type' => self::TYPE_INT),
            'hc_id_product' => array('type' => self::TYPE_INT),
            'st_id_product' => array('type' => self::TYPE_INT),
            'st_id_product_attribute' => array('type' => self::TYPE_INT),
            'st_id_order_detail' => array('type' => self::TYPE_INT),
            'hc_product_sku' => array('type' => self::TYPE_STRING),
            'quantity' => array('type' => self::TYPE_INT),
            'can_refund' => array('type' => self::TYPE_BOOL),
            'refunded' => array('type' => self::TYPE_BOOL),
            'date_add' => array('type' => self::TYPE_DATE)
        ),
    );

    /**
     * Get a Hipercalzado order product list of an id_hipercalzado_order.
     *
     * @param int $id_hipercalzado_order
     *
     * @return array
     */
    public static function getList($id_hipercalzado_order)
    {
        return Db::getInstance()->executeS('SELECT * FROM `' . _DB_PREFIX_ . 'hipercalzado_order_product` WHERE `id_hipercalzado_order` = ' . (int) $id_hipercalzado_order);
    }

    /**
     * Get Hipercalzado order product by st_id_product and hc_id_product
     *
     * @param $hc_id_order
     * @return false|HipercalzadoOrder
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public static function getHipercalzadoOrderProductByPSIdOrderAndHCProductSku($id_hipercalzado_order, $hc_product_sku)
    {
        $id = Db::getInstance()->getValue(
            'SELECT id_hipercalzado_order_product FROM ' . _DB_PREFIX_ . 'hipercalzado_order_product WHERE id_hipercalzado_order = ' . (int) $id_hipercalzado_order. ' AND hc_product_sku = \'' . pSQL($hc_product_sku) . '\'');

        if (!$id) {
            return false;
        }

        return new HipercalzadoOrderProduct($id);
    }

    /**
     * Get Hipercalzado order product by st_id_product and hc_id_product
     *
     * @param $hc_id_order
     * @return false|HipercalzadoOrder
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public static function getHipercalzadoOrderProductByPSIdOrderDetail($st_id_order_detail)
    {
        $id = Db::getInstance()->getValue(
            'SELECT id_hipercalzado_order_product FROM ' . _DB_PREFIX_ . 'hipercalzado_order_product WHERE st_id_order_detail = ' . (int) $st_id_order_detail);

        if (!$id) {
            return false;
        }

        return new HipercalzadoOrderProduct($id);
    }

    

}
