/**
 * @category   Webkul
 * @package    Webkul_hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
/*jshint jquery:true*/
define([
    'jquery',
    'mage/translate',
    "mage/loader",
    "Magento_Ui/js/modal/alert"
], function ($, $t, loader, alert) {
    'use strict';
    var self;
    var total;
    var skipCount, count;
    $.widget('mage.orderCreateProfiler', {
        _create: function () {
            self = this;
            total = self.options.total;
            if (total > 0) {
                self.importOrder(1, 0);
            }
        },
        importOrder : function (count) {
            count = count;
            $.ajax({
                type: 'POST',
                url:self.options.cretaeOrderUrl,
                async: true,
                dataType: 'json',
                data : {form_key: window.FORM_KEY, count: count, skip: skipCount},
                success:function(data) {
                    if(data['error'] == 1) {
                        $(".fieldset").append($('<div>', {'class' : 'message message-error error'})
                                                .text(data['msg'])
                                            );
                        skipCount++;
                    }
                    var width = (100/total)*count;
                    $(".wk-mu-progress-bar-current").animate({width: width+"%"},'slow', function() {
                        if(count == total) {
                            self.finishImporting(count, skipCount);
                            $(".wk-mu-info-bar").text($.mage.__('Completed'));
                        } else {
                            count++;
                            $(".wk-current").text(count);
                            self.importOrder(count);
                        }
                    });
                }
            });
        },
        finishImporting : function (count, skipCount) {
            $.ajax({
                type: 'POST',
                url:self.options.cretaeOrderUrl,
                async: true,
                dataType: 'json',
                data : {form_key: window.FORM_KEY, count: count, skip: skipCount },
                success:function(data) {
                    $(".fieldset").append(data['msg']);
                }
            });
        }
    });
    return $.mage.orderCreateProfiler;
});
