/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
/*jshint jquery:true*/
define([
    'jquery',
    'mage/loader',
    'mage/template',
], function ($, loader) {
    'use strict';
    var page = 1;var requests = [];var totalImportedOrder = 0;var notifications='';
    var self;
    $.widget('mage.orderImportScript', {
        _create: function () {
            self = this;
            $('#sync_from_hipercalzado-import_order_from_hipercalzado').click (function (e) {
                $('#sync_from_hipercalzado .action-toggle').trigger('click');
                e.preventDefault();
                self.importOrders();   
            });

            $('#sync_from_hipercalzado-profiler_for_create_order').click(function(e) {
                $('#sync_from_hipercalzado .action-toggle').trigger('click');
                window.open(self.options.profilerAjaxUrl);
            });
        },
        importOrders : function () {
            $.ajax({
                url     :   self.options.importAjaxUrl,
                type    :   "POST",
                dataType:   "json",
                showLoader: true,
                data: {
                    form_key: window.FORM_KEY,
                    'page' : page
                },
                success : function(hipercalzadoOrder) {
                    if(hipercalzadoOrder.error_msg != '') {
                        $('<div>').html(hipercalzadoOrder.error_msg)
                        .modal({
                            title: $.mage.__('Attention'),
                            autoOpen: true,
                            buttons: [{
                             text: 'OK',
                                attr: {
                                    'data-action': 'cancel'
                                },
                                'class': 'action-primary',
                                click: function() {
                                    this.closeModal();
                                }
                            }]
                        });
                    } else if (hipercalzadoOrder.total_imported == false) {
                           page = page+1;
                           totalImportedOrder = totalImportedOrder + hipercalzadoOrder.data;
                           notifications = notifications+hipercalzadoOrder.notification;
                           self.importOrders();
                   } else {
                       if (hipercalzadoOrder.total_imported == true) {
                           totalImportedOrder = totalImportedOrder + hipercalzadoOrder.data
                           var msg =$.mage.__('Total ')+totalImportedOrder +$.mage.__(' orders imported in your store from hipercalzado.');
                           if (totalImportedOrder == 0) {
                               msg = $.mage.__('All the orders are already imported. There is no new order to import.');
                           }
                           msg += totalImportedOrder ? $.mage.__(' Now run order profiler for create these order in your store') : '';
                           var notification = '';
                           notifications = notifications+hipercalzadoOrder.notification;
                           if ($('<div>').html(notifications).text() != '') {
                               var actionMsg = $.mage.__('For import following orders please follow : <br>');
                               var actionForCreatePro = "<b>hipercalzado Account >> Map Product >> Run Profiler</b>";
                               notification = '<div class="message notification">'+actionMsg
                                                       +actionForCreatePro+'</div><div style="color:red;">'
                                                       +hipercalzadoOrder.notification+notifications+'</div>';
                           }
                           $('<div>').html(msg+notification)
                               .modal({
                                   title: $.mage.__('Attention'),
                                   autoOpen: true,
                                   buttons: [{
                                    text: 'OK',
                                       attr: {'data-action': 'cancel'},
                                       'class': 'action-primary',
                                       click: function () {
                                               this.closeModal();
                                           }
                                   }]
                               });
                       }
                       page = 1;
                       totalImportedOrder = 0;
                       notifications = '';
                    }
                }
            });
        }
    });
    return $.mage.orderImportScript;
});
