<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */

namespace Webkul\Hipercalzado\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\LocalizedException;

class ProductAfterDelete implements ObserverInterface
{

    /**
     * @param \Magento\InventorySales\Model\ResourceModel\DeleteReservationsBySkus $deleteReservationsBySkus,
     * @param \Webkul\Hipercalzado\Logger\Logger $logger,
     */

     public function __construct(
        \Magento\InventorySales\Model\ResourceModel\DeleteReservationsBySkus $deleteReservationsBySkus,
        \Webkul\Hipercalzado\Logger\Logger $logger
    ) {
        $this->deleteReservationsBySkus = $deleteReservationsBySkus;
        $this->logger = $logger;
    }

    /**
     * Call product delete
     * after delete product from Magento
     *
     * @param   Observer $observer
     * @return  $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        try {
            $eventProduct = $observer->getEvent()->getProduct();
            $sku = $eventProduct->getSku();
            
            if ($sku) {
                $this->deleteReservationsBySkus->execute([$sku]);
            }

        } catch (\Exception $e) {
            $this->logger->critical('product delete : '.$e->getMessage());
            return $this;
        }

    }
}