<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */

namespace Webkul\Hipercalzado\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\LocalizedException;

class OrderStateChange implements ObserverInterface
{

    public const BASE_URL = 'https://www.menuweb.es/seller/api/';
    public const TEST_BASE_URL = 'https://test.menuweb.es/seller/api/';
	public const METHOD_ORDERS = 'orders';

    /**
     * @var \Magento\Framework\HTTP\Client\Curl
     */
    private $curl;

    /**
     * @var \Webkul\Hipercalzado\Logger\Logger
     */
    private $hipercalzadoLogger;

    /**
     * @var \Webkul\Hipercalzado\Model\OrdermapFactory
     */
    private $orderMapRecord;

    /**
     * @var \Webkul\Hipercalzado\Helper\Data
     */
    private $helper;

    /**
     * @param \Magento\Framework\HTTP\Client\Curl $curl,
     * @param \Webkul\Hipercalzado\Logger\Logger $hipercalzadoLogger,
     * @param \Webkul\Hipercalzado\Model\OrdermapFactory $orderMapRecord,
     * @param \Webkul\Hipercalzado\Helper\Data $helper
     */
    public function __construct(
        \Magento\Framework\HTTP\Client\Curl $curl,
        \Webkul\Hipercalzado\Logger\Logger $hipercalzadoLogger,
        \Webkul\Hipercalzado\Model\Ordermap $orderMapRecord,
        // \Webkul\Hipercalzado\Helper\Data $helper,
        \Magento\Framework\Json\Helper\Data $jsonHelperData
    ) {
        $this->curl = $curl;
        $this->logger = $hipercalzadoLogger;
        $this->orderMapRecord = $orderMapRecord;
        // $this->helper = $helper;
        $this->jsonHelper = $jsonHelperData;
        $this->objectManager = \Magento\Framework\App\ObjectManager::getInstance();
    }
    /**
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        try {
            $order = $observer->getEvent()->getOrder();
            $scope = $this->objectManager->get('Magento\Framework\App\Config\ScopeConfigInterface');
            $orderNotify = $scope->getValue('hipercalzado/general_settings/hipercalzado_order_notify');
            $orderCancel = $scope->getValue('hipercalzado/general_settings/hipercalzado_order_cancel');
            $orderDefault = $scope->getValue('hipercalzado/general_settings/hipercalzado_order_default');

            $mapedOrder = $this->orderMapRecord->getCollection()
                ->addFieldToFilter('mage_order_id', ['eq' => $order->getRealOrderId()])->setPageSize(1)->getFirstItem();
                            $this->logger->info('Observer status getRealOrderId '.$order->getRealOrderId());
                            $this->logger->info('Observer status getEntityId'.$mapedOrder->getEntityId());

            if ($mapedOrder->getEntityId()) {

                if($track = $order->getTracksCollection()->fetchItem()){
                    $post_fields = Array(
                        'carrier_code' => $track->getTitle(),
                        'carrier_name' => $track->getTitle(),
                        'tracking_number' => $track->getTrackNumber()
                    );
                    $url = self::TEST_BASE_URL . self::METHOD_ORDERS . '/'.$mapedOrder->getHipercalzadoOrderId().'/tracking';
                    $return = $this->apiCall($post_fields,$url);
                    $this->logger->info('Observer track return '.json_encode($return));
                }

                if($order->getStatus() == $orderNotify &&  !empty($orderNotify) && $orderDefault != $orderNotify && $return['status']){
                    $return = $this->apiCallShip($mapedOrder->getHipercalzadoOrderId());
                    $this->logger->info('Observer ProcessShipment return '.json_encode($return));
                }

                elseif($order->getStatus() == $orderCancel &&  !empty($orderCancel) && $orderDefault != $orderCancel){
                    $tempOrder = $this->jsonHelper->jsonDecode($mapedOrder->getData('temp_data'));
                        if ($tempOrder['can_cancel']) {
                            foreach ($tempOrder['items'] as $item) {
                                $order_lines[] = Array(
                                    'accept' => false,
                                    'total_refuse' => $item['quantity'],
                                    'id' => $item['order_line_id'],
                                );
                            }
                            $post_fields = Array(
                                'order_lines' => $order_lines,
                                'cancellation_reason' => "solicitado_cancelacion"
                            );
                            $url = self::TEST_BASE_URL . self::METHOD_ORDERS . '/'.$mapedOrder->getHipercalzadoOrderId().'/accept';
                            $return = $this->apiCall($post_fields,$url);
                            $this->logger->info('Observer Order cancel return'.json_encode($return));
                            // $this->logger->info('Observer Order cancel post_fields'.json_encode($post_fields));
                        }
                }
            }
                
        } catch (\Exception $e) {
            $this->logger->critical('Observer ProcessShipment'.$e->getMessage());
        }
    }

    public function apiCallShip($orderId)
    {
        try {
            $key = $this->objectManager->get('Magento\Framework\App\Config\ScopeConfigInterface')
                   ->getValue('hipercalzado/general_settings/hipercalzado_user_token');
            if(empty($key) || is_null($key)){
                return ['status'=>false, 'msg'=> __('Empty user token')];  
            }
            $url = self::TEST_BASE_URL . self::METHOD_ORDERS . '/'.$orderId.'/ship';

            $this->curl->addHeader("Content-Type", 'application/json');
            $this->curl->addHeader("Authorization", $key);
            $arr = [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'PUT'
            ];

            $this->curl->setOptions($arr);
            $this->curl->get($url);
            $this->logger->critical("Hipercalzado ship API body :".$this->curl->getBody());
            $this->logger->critical("Hipercalzado ship API status :".$this->curl->getStatus());
            if ($this->curl->getStatus() != 200 && $this->curl->getStatus() != 204) {
                return ['status'=>false, 'msg'=> $this->jsonHelper->jsonDecode($this->curl->getBody())[0]["message"]];
            } elseif ($this->curl->getStatus() == 200) {
                $data['status'] = true;
                $data['data'] = $this->jsonHelper->jsonDecode($this->curl->getBody());
                return $data;
            }
            elseif ($this->curl->getStatus() == 204) {
                $data['status'] = true;
                return $data;
            }
        } catch (\Exception $e) {
             $this->logger->critical("Hipercalzado ship APICall :".$e->getMessage());
        }
    }

    public function apiCall($post_fields,$url)
    {
        try {
            $key =  $this->objectManager->get('Magento\Framework\App\Config\ScopeConfigInterface')
                  ->getValue('hipercalzado/general_settings/hipercalzado_user_token');
            if(empty($key) || is_null($key)){
                return ['status'=>false, 'msg'=> __('Empty user token')];  
            }
            

            $this->curl->addHeader("Content-Type", 'application/json');
            $this->curl->addHeader("Authorization", $key);
            $post_fields = $this->jsonHelper->jsonEncode($post_fields);
            $arr = [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'PUT',
                CURLOPT_POSTFIELDS => $post_fields
            ];

            $this->curl->setOptions($arr);
            $this->curl->get($url);
            $this->logger->critical("Hipercalzado accept API body :".$this->curl->getBody());
            $this->logger->critical("Hipercalzado accept API status :".$this->curl->getStatus());
            if ($this->curl->getStatus() != 200 && $this->curl->getStatus() != 204) {
                return ['status'=>false, 'msg'=> $this->jsonHelper->jsonDecode($this->curl->getBody())[0]["message"]];
            } elseif ($this->curl->getStatus() == 200) {
                $data['status'] = true;
                $data['data'] = $this->jsonHelper->jsonDecode($this->curl->getBody());
                return $data;
            }
            elseif ($this->curl->getStatus() == 204) {
                $data['status'] = true;
                return $data;
            }
        } catch (\Exception $e) {
             $this->logger->critical("Hipercalzado accept APICall :".$e->getMessage());
        }
    }

}
