<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\Hipercalzado\Observer;

use Magento\Framework\Event\ObserverInterface;

class ChangeTaxTotal implements ObserverInterface
{
    /**
     * @var \Magento\Backend\Model\Session
     */
    private $backendSession;

    /**
     * @var \Webkul\Hipercalzado\Logger\Logger
     */
    private $logger;

    /**
     * @param \Magento\Backend\Model\Session $backendSession,
     * @param \Webkul\Hipercalzado\Logger\Logger $logger,
     */

    public function __construct(
        \Magento\Backend\Model\Session $backendSession,
        \Webkul\Hipercalzado\Logger\Logger $logger
    ) {
        $this->backendSession = $backendSession;
        $this->logger = $logger;
    }

    /**
     * @param \Magento\Framework\Event\Observer $observer
     * @return $this
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        try {
            /** @var Magento\Quote\Model\Quote\Address\Total */
            $additionalTaxAmt = $this->backendSession->getHipercalzadoTotalTaxAmount();
            $total = $observer->getData('total');
            //make sure tax value exist
            if ($additionalTaxAmt) {
                $total->setTotalAmount('tax', $additionalTaxAmt['total_tax']);
                $total->setBaseTotalAmount('tax', $additionalTaxAmt['base_total_tax']);
                $total->setGrandTotal($total->getGrandTotal() + $additionalTaxAmt['total_tax']);
                $total->setBaseGrandTotal($total->getBaseGrandTotal() + $additionalTaxAmt['base_total_tax']);
                $this->logger->info('ChangeTaxTotal check  : '.$additionalTaxAmt);
            }
            return $this;
        } catch (\Exception $e) {
            $this->logger->critical('ChangeTaxTotal : '.$e->getMessage());
            return $this;
        }
    }
}
