<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\Hipercalzado\Model;

use Webkul\Hipercalzado\Api\Data\ProductmapInterface;
use Webkul\Hipercalzado\Model\ResourceModel\Productmap\Collection;

/**
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 * @SuppressWarnings(PHPMD.TooManyFields)
 */
class ProductmapRepository implements \Webkul\Hipercalzado\Api\ProductmapRepositoryInterface
{
    /**
     * resource model
     * @var \Webkul\Hipercalzado\Model\ResourceModel\Productmap
     */
    protected $_resourceModel;

    public function __construct(
        ProductmapFactory $productmapFactory,
        \Webkul\Hipercalzado\Model\ResourceModel\Productmap\CollectionFactory $collectionFactory,
        \Webkul\Hipercalzado\Model\ResourceModel\Productmap $resourceModel
    ) {
        $this->_resourceModel = $resourceModel;
        $this->_productmapFactory = $productmapFactory;
        $this->_collectionFactory = $collectionFactory;
    }
    
    /**
     * get Hipercalzado sync collection of product by Hipercalzado rule id
     * @return object
     */
    public function getCollectionByRuleId($ruleId)
    {
        $synProductCollection =  $this->_productmapFactory->create()
            ->getCollection()
            ->addFieldToFilter(
                'rule_id',
                [
                    'eq'=>$ruleId
                ]
            );
        return $synProductCollection;
    }

    /**
     * get collection by Hipercalzado product id
     * @param  int $hipercalzadoProductId
     * @return object
     */
    public function getRecordByHipercalzadoProductId($hipercalzadoProductId)
    {
        $synProductCollection =  $this->_productmapFactory->create()
            ->getCollection()
            ->addFieldToFilter(
                'Hipercalzado_pro_id',
                [
                    'eq'=>$hipercalzadoProductId
                ]
            );
        return $synProductCollection;
    }

    /**
     * get record by magento product id
     * @param  int $mageProductId
     * @return object
     */
    public function getRecordByMageProductId($mageProductId)
    {
        $synProductCollection =  $this->_productmapFactory->create()
            ->getCollection()
            ->addFieldToFilter(
                'magento_pro_id',
                [
                    'eq'=>$mageProductId
                ]
            );
        return $synProductCollection;
    }

    /**
     * get collection by entity ids
     * @param  array $entityIds
     * @return object
     */
    public function getCollectionByIds(array $entityIds)
    {
        $synProductCollection =  $this->_productmapFactory->create()
            ->getCollection()
            ->addFieldToFilter(
                'entity_id',
                [
                    'in'=>$entityIds
                ]
            );
        return $synProductCollection;
    }
}
