<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Hipercalzado
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */

namespace Webkul\Hipercalzado\Model;

/**
 * Hipercalzado OrdermapRepository Class
 */
class OrdermapRepository implements \Webkul\Hipercalzado\Api\OrdermapRepositoryInterface
{
    /**
     * @var \Webkul\Hipercalzado\Model\OrdermapFactory
     */
    protected $modelFactory = null;

    /**
     * @var \Webkul\Hipercalzado\Model\ResourceModel\Ordermap\CollectionFactory
     */
    protected $collectionFactory = null;

    /**
     * Initialize
     *
     * @param \Webkul\Hipercalzado\Model\OrdermapFactory $modelFactory
     * @param \Webkul\Hipercalzado\Model\ResourceModel\Ordermap\CollectionFactory $collectionFactory
     * @return void
     */
    public function __construct(
        \Webkul\Hipercalzado\Model\OrdermapFactory $modelFactory,
        \Webkul\Hipercalzado\Model\ResourceModel\Ordermap\CollectionFactory $collectionFactory
    ) {
        $this->modelFactory = $modelFactory;
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * Get by id
     *
     * @param int $id
     * @return \Webkul\Hipercalzado\Model\Ordermap
     */
    public function getById($id)
    {
        $model = $this->modelFactory->create()->load($id);
        if (!$model->getId()) {
            throw new \Magento\Framework\Exception\NoSuchEntityException(
                __('The Order map with the "%1" ID doesn\'t exist.', $id)
            );
        }
        return $model;
    }

    /**
     * Save
     *
     * @param \Webkul\Hipercalzado\Model\Ordermap $subject
     * @return \Webkul\Hipercalzado\Model\Ordermap
     */
    public function save(\Webkul\Hipercalzado\Model\Ordermap $subject)
    {
        try {
            $subject->save();
        } catch (\Exception $exception) {
            throw new \Magento\Framework\Exception\CouldNotSaveException(
                __($exception->getMessage())
            );
        }
         return $subject;
    }

    /**
     * Get list
     *
     * @param Magento\Framework\Api\SearchCriteriaInterface $creteria
     * @return Magento\Framework\Api\SearchResults
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $creteria)
    {
        $collection = $this->collectionFactory->create();
        return $collection;
    }

    /**
     * Delete
     *
     * @param \Webkul\Hipercalzado\Model\Ordermap $subject
     * @return boolean
     */
    public function delete(\Webkul\Hipercalzado\Model\Ordermap $subject)
    {
        try {
            $subject->delete();
        } catch (\Exception $exception) {
            throw new \Magento\Framework\Exception\CouldNotDeleteException(__($exception->getMessage()));
        }
        return true;
    }

    /**
     * Delete by id
     *
     * @param int $id
     * @return boolean
     */
    public function deleteById($id)
    {
        return $this->delete($this->getById($id));
    }
}
