<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Hipercalzado
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */

namespace Webkul\Hipercalzado\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;
use Webkul\Hipercalzado\Api\Data\OrdermapInterface;

/**
 * Hipercalzado Ordermap Class
 */
class Ordermap extends AbstractModel implements IdentityInterface, OrdermapInterface
{

    public const NOROUTE_ENTITY_ID = 'no-route';

    public const CACHE_TAG = 'webkul_hipercalzado_ordermap';

    /**
     * @var string
     */
    protected $_cacheTag = 'webkul_hipercalzado_ordermap';

    /**
     * @var string
     */
    protected $_eventPrefix = 'webkul_hipercalzado_ordermap';

    /**
     * Set resource model
     */
    public function _construct()
    {
        $this->_init(\Webkul\Hipercalzado\Model\ResourceModel\Ordermap::class);
    }

    /**
     * Load No-Route Indexer.
     *
     * @return $this
     */
    public function noRouteReasons()
    {
        return $this->load(self::NOROUTE_ENTITY_ID, $this->getIdFieldName());
    }

    /**
     * Get identities.
     *
     * @return []
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG.'_'.$this->getId()];
    }

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Hipercalzado\Model\OrdermapInterface
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId()
    {
        return parent::getData(self::ENTITY_ID);
    }

    /**
     * Set HipercalzadoOrderId
     *
     * @param string $hipercalzadoOrderId
     * @return Webkul\Hipercalzado\Model\OrdermapInterface
     */
    public function setHipercalzadoOrderId($hipercalzadoOrderId)
    {
        return $this->setData(self::HIPERCALZADO_ORDER_ID, $hipercalzadoOrderId);
    }

    /**
     * Get HipercalzadoOrderId
     *
     * @return string
     */
    public function getHipercalzadoOrderId()
    {
        return parent::getData(self::HIPERCALZADO_ORDER_ID);
    }

    /**
     * Set MageOrderId
     *
     * @param string $mageOrderId
     * @return Webkul\Hipercalzado\Model\OrdermapInterface
     */
    public function setMageOrderId($mageOrderId)
    {
        return $this->setData(self::MAGE_ORDER_ID, $mageOrderId);
    }

    /**
     * Get MageOrderId
     *
     * @return string
     */
    public function getMageOrderId()
    {
        return parent::getData(self::MAGE_ORDER_ID);
    }

    /**
     * Set Status
     *
     * @param string $status
     * @return Webkul\Hipercalzado\Model\OrdermapInterface
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * Get Status
     *
     * @return string
     */
    public function getStatus()
    {
        return parent::getData(self::STATUS);
    }

    /**
     * Set CreatedAt
     *
     * @param string $createdAt
     * @return Webkul\Hipercalzado\Model\OrdermapInterface
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * Get CreatedAt
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return parent::getData(self::CREATED_AT);
    }
}
