<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Hipercalzado
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */

namespace Webkul\Hipercalzado\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\DataObject\IdentityInterface;
use Webkul\Hipercalzado\Api\Data\ImportedtmpproductInterface;

/**
 * Hipercalzado Importedtmpproduct Class
 */
class Importedtmpproduct extends AbstractModel implements IdentityInterface, ImportedtmpproductInterface
{

    public const NOROUTE_ENTITY_ID = 'no-route';

    public const CACHE_TAG = 'webkul_hipercalzado_importedtmpproduct';

    /**
     * @var string
     */
    protected $_cacheTag = 'webkul_hipercalzado_importedtmpproduct';

    /**
     * @var string
     */
    protected $_eventPrefix = 'webkul_hipercalzado_importedtmpproduct';

    /**
     * Set resource model
     */
    public function _construct()
    {
        $this->_init(\Webkul\Hipercalzado\Model\ResourceModel\Importedtmpproduct::class);
    }

    /**
     * Load No-Route Indexer.
     *
     * @return $this
     */
    public function noRouteReasons()
    {
        return $this->load(self::NOROUTE_ENTITY_ID, $this->getIdFieldName());
    }

    /**
     * Get identities.
     *
     * @return []
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG.'_'.$this->getId()];
    }

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Hipercalzado\Model\ImportedtmpproductInterface
     */
    public function setEntityId($entityId)
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId()
    {
        return parent::getData(self::ENTITY_ID);
    }

    /**
     * Set ItemType
     *
     * @param string $itemType
     * @return Webkul\Hipercalzado\Model\ImportedtmpproductInterface
     */
    public function setItemType($itemType)
    {
        return $this->setData(self::ITEM_TYPE, $itemType);
    }

    /**
     * Get ItemType
     *
     * @return string
     */
    public function getItemType()
    {
        return parent::getData(self::ITEM_TYPE);
    }

    /**
     * Set ItemId
     *
     * @param string $itemId
     * @return Webkul\Hipercalzado\Model\ImportedtmpproductInterface
     */
    public function setItemId($itemId)
    {
        return $this->setData(self::ITEM_ID, $itemId);
    }

    /**
     * Get ItemId
     *
     * @return string
     */
    public function getItemId()
    {
        return parent::getData(self::ITEM_ID);
    }

    /**
     * Set ProductData
     *
     * @param string $productData
     * @return Webkul\Hipercalzado\Model\ImportedtmpproductInterface
     */
    public function setProductData($productData)
    {
        return $this->setData(self::PRODUCT_DATA, $productData);
    }

    /**
     * Get ProductData
     *
     * @return string
     */
    public function getProductData()
    {
        return parent::getData(self::PRODUCT_DATA);
    }

    /**
     * Set CreatedAt
     *
     * @param string $createdAt
     * @return Webkul\Hipercalzado\Model\ImportedtmpproductInterface
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * Get CreatedAt
     *
     * @return string
     */
    public function getCreatedAt()
    {
        return parent::getData(self::CREATED_AT);
    }

    /**
     * Set AssociateProducts
     *
     * @param string $associateProducts
     * @return Webkul\Hipercalzado\Model\ImportedtmpproductInterface
     */
    public function setAssociateProducts($associateProducts)
    {
        return $this->setData(self::ASSOCIATE_PRODUCTS, $associateProducts);
    }

    /**
     * Get AssociateProducts
     *
     * @return string
     */
    public function getAssociateProducts()
    {
        return parent::getData(self::ASSOCIATE_PRODUCTS);
    }

    /**
     * Set TotalAssociate
     *
     * @param int $totalAssociate
     * @return Webkul\Hipercalzado\Model\ImportedtmpproductInterface
     */
    public function setTotalAssociate($totalAssociate)
    {
        return $this->setData(self::TOTAL_ASSOCIATE, $totalAssociate);
    }

    /**
     * Get TotalAssociate
     *
     * @return int
     */
    public function getTotalAssociate()
    {
        return parent::getData(self::TOTAL_ASSOCIATE);
    }

    /**
     * Set Error
     *
     * @param string $error
     * @return Webkul\Hipercalzado\Model\ImportedtmpproductInterface
     */
    public function setError($error)
    {
        return $this->setData(self::ERROR, $error);
    }

    /**
     * Get Error
     *
     * @return string
     */
    public function getError()
    {
        return parent::getData(self::ERROR);
    }
}
