<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */

namespace Webkul\Hipercalzado\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;

class Carrier implements ArrayInterface
{

    /**
     * @param \Magento\Shipping\Model\Config $shipconfig
     * */
    public function __construct(
        \Magento\Shipping\Model\Config $shipconfig
    )
    {
        $this->shipconfig = $shipconfig;
    }


    /*
     * Option getter
     * @return array
     */
    public function toOptionArray()
    {
        $arr = $this->toArray();
        $ret = [];

        foreach ($arr as $key => $value)
        {
            $ret[] = [
                'value' => $key,
                'label' => $value
            ];
        }

        return $ret;
    }

    /*
     * Get options in "key-value" format
     * @return array
     */
    public function toArray(){

        $activeCarriers = $this->shipconfig->getActiveCarriers();
    
        foreach($activeCarriers as $carrierCode => $carrierModel) {
           $options = [];
           $options[''] = __('-- Please Select --');
           if ($carrierMethods = $carrierModel->getAllowedMethods()) {
               foreach ($carrierMethods as $methodCode => $method) {
                    $code = $carrierCode . '_' . $methodCode;
                    $options[$code] =  $method;
               }
            }
    
        }
    
        return $options;    
    }

}