<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\Hipercalzado\Model\Carrier;

use Magento\Quote\Model\Quote\Address\RateRequest;
use Magento\Shipping\Model\Carrier\AbstractCarrier;
use Magento\Shipping\Model\Carrier\CarrierInterface;
use Magento\Framework\Xml\Security;

class CustomShipping extends AbstractCarrier implements CarrierInterface
{
    const CODE = 'wk_hipercalzadoconnector_ship';

    /**
     * @var string
     */
    protected $code = self::CODE;

    /**
     * @var \Magento\Backend\Model\Session
     */
    private $backendSession;

    /**
     * @var \Magento\Shipping\Model\Rate\ResultFactory
     */
    protected $rateFactory;

    /**
     * @var \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory
     */
    protected $rateMethodFactory;

    /**
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
     * @param \Magento\Framework\App\Request\Http $request,
     * @param \Magento\Quote\Model\Quote\Address\RateResult\ErrorFactory $rateErrorFactory,
     * @param \Psr\Log\LoggerInterface $logger,
     * @param \Magento\Backend\Model\Session\Proxy $backendSession,
     * @param \Magento\Shipping\Model\Rate\ResultFactory $rateFactory,
     * @param \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory $rateMethodFactory,
     * @param array $data = []
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Quote\Model\Quote\Address\RateResult\ErrorFactory $rateErrorFactory,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Backend\Model\Session $backendSession,
        \Magento\Shipping\Model\Rate\ResultFactory $rateFactory,
        \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory $rateMethodFactory,
        array $data = []
    ) {
        $this->backendSession = $backendSession;
        $this->rateFactory = $rateFactory;
        $this->rateMethodFactory = $rateMethodFactory;
        parent::__construct(
            $scopeConfig,
            $rateErrorFactory,
            $logger,
            $data
        );
    }

    protected function _doShipmentRequest(\Magento\Framework\DataObject $request)
    {
        /** no need  */
    }

    /**
     * @return array
     */
    public function getAllowedMethods()
    {
        return ['wk_hipercalzadoconnector_ship' => 'wk_hipercalzadoconnector_ship'];
    }

    public function collectRates(RateRequest $request)
    {
        //get shipping data from session
        $shipInfo = $this->backendSession->getHipercalzadoShipDetail();
        //$controllerName = $this->request->getControllerName();
        if (!empty($shipInfo) /*&& $controllerName != ''*/) {
            $result = $this->rateFactory->create();
            // dd($shipInfo['method']);
            $method = $this->rateMethodFactory->create();
            $method->setCarrier('wk_hipercalzadoconnector_ship');
            $method->setCarrierTitle($shipInfo['method']);
            // Use method name
            $method->setMethod('wk_hipercalzadoconnector_ship');
            $method->setMethodTitle($shipInfo['method']);
            $method->setCost($shipInfo['cost']);
            $method->setPrice($shipInfo['cost']);
            $result->append($method);
            return $result;
        } else {
            return false;
        }
    }

    /**
     * Checks if shipping method can collect rates
     * @return bool
     */
    public function canCollectRates()
    {
        return true;//(bool)$this->getConfigFlag($this->_activeFlag);
    }

    public function proccessAdditionalValidation(\Magento\Framework\DataObject $request)
    {
        return true;
    }
}
