<?php

namespace Webkul\Hipercalzado\Helper;
use \Magento\Framework\App\Helper\AbstractHelper;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\App\Filesystem\DirectoryList;

class Data extends AbstractHelper
{

    public const BASE_URL = 'https://www.menuweb.es/seller/api/';
    public const TEST_BASE_URL = 'https://test.menuweb.es/seller/api/';
	public const METHOD_ORDERS = 'orders';
	public const MAX_ORDERS = 100;

    /**
     * @var \Magento\Framework\HTTP\Client\Curl
     */
    private $curl;

    /**
     * @var \Magento\Framework\Json\Helper\Data
     */
    private $jsonHelper;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    private $storeManager;


    /**
     * Constructor.
     *
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Framework\HTTP\Client\Curl $curl
     * @param \Magento\Framework\Json\Helper\Data $jsonHelper
     * @param \Webkul\Hipercalzado\Logger\Logger $logger
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Framework\HTTP\Client\Curl $curl,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        \Webkul\Hipercalzado\Logger\Logger $logger,
        \Webkul\Hipercalzado\Model\ImportedtmpproductFactory $importedTmpProduct,
        \Webkul\Hipercalzado\Model\Ordermap $orderMapRecord,
        StoreManagerInterface $storeManager,
        \Magento\Directory\Model\CurrencyFactory $currencyFactory,
        \Magento\Directory\Model\Region $region,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $dateTime,
        \Webkul\Hipercalzado\Model\Storage\DbStorage $dbStorage,
        \Magento\Catalog\Api\ProductRepositoryInterface $productRepository,
        \Magento\ConfigurableProduct\Model\Product\Type\Configurable $configurableProTypeModel,
        \Magento\Catalog\Helper\Product $productHelper,
        \Webkul\Hipercalzado\Model\Productmap $productMapRecord,
        \Webkul\Hipercalzado\Model\ProductmapFactory $productmapFactory,
        \Magento\Customer\Model\CustomerFactory $customerFactory,
        \Magento\Quote\Api\CartManagementInterface $cartManagementInterface,
        \Magento\Quote\Api\CartRepositoryInterface $cartRepositoryInterface,
        \Magento\Sales\Model\Order $order,
        \Magento\Customer\Api\CustomerRepositoryInterface $customerRepository,
        \Magento\Framework\Filesystem $filesystem,
        \Magento\Framework\Filesystem\Driver\File $fileSystemDriver,
        \Magento\Framework\Math\Random $random,
        \Magento\Store\Model\App\Emulation $emulation,
        \Magento\Catalog\Controller\Adminhtml\Product\Initialization\Helper $initializationHelper,
        \Magento\Catalog\Model\Product\TypeTransitionManager $productTypeManager,
        \Magento\Framework\Data\Form\FormKey $formkey,
        \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry,
        \Magento\Catalog\Controller\Adminhtml\Product\Builder $productBuilder,
        \Magento\Framework\DataObjectFactory $dataObject,
        \Magento\Framework\App\RequestInterface $request,
        \Magento\Catalog\Model\Product $product,
        \Magento\Quote\Model\Quote\Address\Rate $shippingRate,
        \Magento\Backend\Model\Session $backendSession,
        \Magento\Framework\Registry $registry,
        DirectoryList $directoryList,
        \Magento\Framework\Filesystem\Io\File $ioFile,
        \Magento\InventorySales\Model\ResourceModel\DeleteReservationsBySkus $deleteReservationsBySkus,
    ) {
        $this->curl = $curl;
        $this->jsonHelper = $jsonHelper;
        $this->logger = $logger;
        $this->importedTmpProduct = $importedTmpProduct;
        $this->orderMapRecord = $orderMapRecord;
        $this->storeManager = $storeManager;
        $this->currencyFactory = $currencyFactory;
        $this->region = $region;
        $this->dateTime = $dateTime;
        $this->dbStorage = $dbStorage;
        $this->productRepository = $productRepository;
        $this->configurableProTypeModel = $configurableProTypeModel;
        $this->productHelper = $productHelper;
        $this->productMapRecord = $productMapRecord;
        $this->productmapFactory = $productmapFactory;
        $this->customerFactory = $customerFactory;
        $this->cartManagementInterface = $cartManagementInterface;
        $this->cartRepositoryInterface = $cartRepositoryInterface;
        $this->order = $order;
        $this->customerRepository = $customerRepository;
        $this->filesystem = $filesystem;
        $this->fileSystemDriver = $fileSystemDriver;
        $this->random = $random;
        $this->emulation = $emulation;
        $this->initializationHelper = $initializationHelper;
        $this->productTypeManager = $productTypeManager;
        $this->formkey = $formkey;
        $this->stockRegistry = $stockRegistry;
        $this->productBuilder = $productBuilder;
        $this->dataObject = $dataObject;
        $this->request = $request;
        $this->product = $product;
        $this->shippingRate = $shippingRate;
        $this->backendSession = $backendSession;
        $this->registry = $registry;
        $this->directoryList = $directoryList;
        $this->ioFile = $ioFile;
        $this->deleteReservationsBySkus = $deleteReservationsBySkus;
        parent::__construct($context);
    }

    /**
     * Authorize key 
     *
     * @param array $key
     * @return array
     */
    public function authorizeKey($key)
    {
        try {
            $url = self::TEST_BASE_URL . self::METHOD_ORDERS . '?max=1';

            $this->curl->addHeader("Content-Type", 'application/json');
            $this->curl->addHeader("Authorization", $key);

            $arr = [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            ];
            $this->curl->setOptions($arr);
            $this->curl->get($url);
            if ($this->curl->getStatus() != 200) {
                return ['status'=>false, 'msg'=> $this->jsonHelper->jsonDecode($this->curl->getBody())[0]["message"]];
            } elseif ($this->curl->getStatus() == 200) {
                $data['msg'] = __('Verified Token');
                $data['status'] = true;
                return $data;
            }
        } catch (\Exception $e) {
             $this->logger->critical("Hipercalzado authorizeKey :".$e->getMessage());
            return [
                'status'=>false,
                'msg'=>__('Please try again and check the log.')
            ];
        }
    }

    /**
     * Get orders
     *
     * @param array $key
     * @return array
     */
    public function getOrders()
    {
        try {
            $key = $this->scopeConfig->getValue('hipercalzado/general_settings/hipercalzado_user_token');
            if(empty($key) || is_null($key)){
                return ['status'=>false, 'msg'=> __('Empty user token')];  
            }
            $url = self::TEST_BASE_URL . self::METHOD_ORDERS . '?max='.self::MAX_ORDERS;

            $this->curl->addHeader("Content-Type", 'application/json');
            $this->curl->addHeader("Authorization", $key);

            $arr = [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            ];
            $this->curl->setOptions($arr);
            $this->curl->get($url);
            if ($this->curl->getStatus() != 200) {
                return ['status'=>false, 'msg'=> $this->jsonHelper->jsonDecode($this->curl->getBody())[0]["message"]];
            } elseif ($this->curl->getStatus() == 200) {
                $data['status'] = true;
                $data['orders'] = $this->jsonHelper->jsonDecode($this->curl->getBody());
                return $data;
            }
        } catch (\Exception $e) {
             $this->logger->critical("Hipercalzado get order :".$e->getMessage());
            return [
                'status'=>false,
                'msg'=>__('Please try again and check the log.')
            ];
        }
    }

    /**
     * CurrencyConvert
     *
     * @param float $amountValue
     * @param string|null $currencyCodeFrom
     * @param string|null $currencyCodeTo
     * @return float
     */
    public function currencyConvert($amountValue, $currencyCodeFrom = null, $currencyCodeTo = null)
    {
        if (!$currencyCodeFrom) {
            $currencyCodeFrom = $this->storeManager->getStore()->getCurrentCurrency()->getCode();
        }

        if (!$currencyCodeTo) {
            $currencyCodeTo = $this->storeManager->getStore()->getBaseCurrency()->getCode();
        }

        if ($currencyCodeFrom == $currencyCodeTo) {
            return $amountValue;
        }

        // $rate = $this->currencyFactory->create()->load($currencyCodeFrom)->getRate($currencyCodeTo);
        $rate = $this->storeManager->getStore()->getBaseCurrency()->getRate($currencyCodeFrom);
        $rate = 1 / $rate;
        $amountValue = $amountValue * $rate;
        return $amountValue;
    }

    /**
     * GetOrderRegion
     *
     * @param array $shippingAddress
     * @return string
     */
    private function getOrderRegion($shippingAddress)
    {
        $region = $shippingAddress['state'];
        $addState = [];
        $countryId = $shippingAddress['country_iso_code'];
        $regionData = $this->region->loadByName($region, $countryId);
        $regionList = $this->region->getCollection()
                            ->addFieldToFilter('country_id', ['eq' => $shippingAddress['country_iso_code']])
                            ->getData();
        if (!empty($regionList)) {
            if ($regionData->getRegionId()) {
                $region = $regionData->getRegionId();
            } else {
                $addState['country_id'] = $countryId;
                $addState['code'] = $region;
                $addState['default_name'] = $region;
                $region = $this->region->setData($addState)->save()->getRegionId();
            }
        }
        return $region;
    }

    /**
     * InsertMultipleRows
     *
     * @param array $tempdata
     * @return int
     */
    public function insertMultipleRows($tempdata)
    {
        if (!empty($tempdata)) {
            return $this->dbStorage->insertMultiple($tempdata, 'wk_hipercalzado_temp');
        }
        return 0;
    }


    /**
     * ManageOrderRawData
     *
     * @param array $hipercalzadoOrders
     * @param Object $client
     * @param boolen $viaCron
     * @return array
     */
    public function manageOrderRawData($orders)
    {
        try {
            $notifications = [];
            $tempdata = [];
            $items = [];
            $errorMsg = '<br/>';
            $shipCost = 0;
            $tempAvlImported = $this->importedTmpProduct->create()->getCollection()
                                    ->addFieldToFilter('item_type', ['eq' => 'order'])
                                    ->getColumnValues('item_id');
            $alreadyMapped = $this->orderMapRecord->getCollection()->getColumnValues('hipercalzado_order_id');
            $tempAvlImported = array_merge($tempAvlImported, $alreadyMapped);
            // $importOrder = $this->scopeConfig->getValue('/order_sync/import_order_type');
            // $importOrder = explode(',', $importOrder);
            foreach ($orders as $hipercalzadoOrder) {
                // if (!in_array($hipercalzadoOrder['OrderStatus'], $importOrder)) {
                //     continue;
                // }
                if (!in_array($hipercalzadoOrder['order_id'], $tempAvlImported)) {
                    /** skip canclled order if only active order import configured  */
                    $shipMethod = __('From hipercalzado ');
                    if (isset($hipercalzadoOrder['shipping_company'])) {
                        $shipMethod .= $hipercalzadoOrder['shipping_company'];
                        $shipCost = isset($hipercalzadoOrder['shipping_price']) ?
                            $hipercalzadoOrder['shipping_price'] : 0;

                        $baseCurrency = $this->storeManager->getStore()->getBaseCurrency()->getCode();
                        $shipCost = $this->currencyConvert(
                            $shipCost , $hipercalzadoOrder['currency_iso_code']
                        );
                    }

                    $carrier = $this->scopeConfig->getValue('hipercalzado/general_settings/hipercalzado_carrier');

                    if(!empty($carrier) && $carrier != 'wk_hipercalzadoconnector_ship_wk_hipercalzadoconnector_ship'){
                        $shipMethod = $carrier;
                    }

                    $orderItemsData = $this->getOrderItemList(
                        $hipercalzadoOrder,
                        $hipercalzadoOrder['order_id'],
                    );
                    if (isset($hipercalzadoOrder['taxes']['amount'])) {
                        $orderItemsData['total_tax'] += $hipercalzadoOrder['taxes']['amount'] ?? 0;
                    }
                    if (!$orderItemsData['invalid_order']) {
                        foreach ($hipercalzadoOrder['customer']['shipping_address'] as $key => $value) {
                            $hipercalzadoOrder['customer']['shipping_address'][$key] = ($value == '') ?  __('NA') : $value;
                        }
                        if (!isset($hipercalzadoOrder['customer']['shipping_address']['country'])) {
                            $hipercalzadoOrder['customer']['shipping_address']['country'] = __('NA');
                        }
                        $regionName = $hipercalzadoOrder['customer']['shipping_address']['state'];
                        $hipercalzadoOrder['customer']['shipping_address']['state'] =
                            preg_match('/[\'^£$%&*()}{@#~?><>,|=_+¬-]/', $regionName) ? 'Other' : $regionName;
                        $region = $this->getOrderRegion($hipercalzadoOrder['customer']['shipping_address']);
                        $email = $orderItemsData['buyer_email'];

                        // $paymentMethods = $hipercalzadoOrder['payment_type'] ?? $hipercalzadoOrder['payment_type'];
                        $paymentMethod = 'hipercalzado';
                        
                        $tempOrder = [
                            'can_cancel' => $hipercalzadoOrder['can_cancel'],
                            'hipercalzado_order_id' => $hipercalzadoOrder['order_id'],
                            'order_status' => $hipercalzadoOrder['order_state'],
                            'created_at' => $hipercalzadoOrder['acceptance_decision_date'],
                            'payment_detail' => [
                                'payment_methods' => implode(" ", preg_split('/(?<=[a-z])(?=[A-Z])/x', $paymentMethod)),
                            ],
                            'email' => $email,
                            'shipping_address' => [
                                'firstname' => $orderItemsData['firstname'] ? $orderItemsData['firstname'] : 'N/A',
                                'lastname' => $orderItemsData['lastname'],
                                'street' => $hipercalzadoOrder['customer']['shipping_address']['street_1']."\r\n"
                                                            .$hipercalzadoOrder['customer']['shipping_address']['street_2'],
                                'city' => $hipercalzadoOrder['customer']['shipping_address']['city'],
                                'country_id' => $hipercalzadoOrder['customer']['shipping_address']['country_iso_code'],
                                'country_name' => $hipercalzadoOrder['customer']['shipping_address']['country'],
                                'region' => $hipercalzadoOrder['customer']['shipping_address']['state'],
                                'region_id' => $region,
                                'postcode' => $hipercalzadoOrder['customer']['shipping_address']['zip_code'],
                                'telephone' => $hipercalzadoOrder['customer']['shipping_address']['phone'],
                                'fax' => $hipercalzadoOrder['customer']['shipping_address']['phone'],
                                'vat_id' => '',
                                'save_in_address_book' => 1
                            ],
                            'items' => $hipercalzadoOrder['order_lines'],
                            'shipping_service' => [
                                'method' => $shipMethod,
                                'cost' => $shipCost ? $shipCost : $orderItemsData['ship_price']
                            ],
                            'total_tax' => $orderItemsData['total_tax'],
                            'currency_iso_code' => $hipercalzadoOrder['currency_iso_code']
                        ];

                        
                        $dt = $this->dateTime->date();
                        $currentDate = $dt->format('Y-m-d\TH:i:s');
                        $tempdata[] = [
                            'item_type' => 'order',
                            'item_id' => $tempOrder['hipercalzado_order_id'],
                            'product_data' => $this->jsonHelper->jsonEncode($tempOrder),
                            'created_at' => $currentDate,
                        ];
                        array_push($items, $tempOrder['hipercalzado_order_id']);
                        
                    } else {
                        $errorMsg = $errorMsg.$orderItemsData['error_msg'];
                    }
                }
            }
            /** insert data in temp table */
            $this->insertMultipleRows($tempdata);
            $notifications['errorMsg'] = $errorMsg;
            $notifications['items'] = $items;
            return $notifications;
        } catch (\Exception $e) {
            $this->logger->critical('manageOrderRawData : '.$e->getMessage());
            return ['errorMsg' => $e->getMessage(), 'items' => $items];
        }
    }

    /**
     * GetOrderItemList
     *
     * @param array $transactionList
     * @param varchar $orderId
     * @param Object $client
     * @param boolen $viaCron
     * @return array
     */
    private function getOrderItemList($transactionList, $orderId)
    {
        try {
            
            $firstname = 'Guest';
            $lastname = 'User';
            $shipPrice = 0;
            $flagSetName = true;
            $invalidOrder = false;
            $orderItems = [];
            $errorMsg = '';
            $productId = 0;
            $buyerEmail = '';
            $totalTax = 0;

            foreach ($transactionList['order_lines'] as $transaction) {
                if (isset($transactionList['customer']['firstname']) && $flagSetName) {
                    $firstname = $transactionList['customer']['firstname'];
                    $lastname = $transactionList['customer']['lastname'];
                    $flagSetName = false;
                }
                if($transaction['shipping_price']>0){
                    $shipPrice =  $shipPrice + $transaction['shipping_price'];
                }
                if($transaction['taxes']['amount']>0){
                    $totalTax = $totalTax + $transaction['taxes']['amount'];
                }
                
                $buyerEmail = isset($transactionList['customer_notification_email']) ? $transactionList['customer_notification_email'] : '';
                if (!filter_var($buyerEmail, FILTER_VALIDATE_EMAIL)) {
                    $domain = explode('.', $this->storeManager->getStore()->getBaseUrl(), 2);
                    $domain = explode('/', $domain[1], 2);
                    $domain = filter_var($domain[0], FILTER_VALIDATE_URL) ? $domain[0] : 'yourdomain.com';
                    $buyerEmail = $firstname.$lastname.rand(1000, 99999).'@'.$domain;
                }
            }

            $baseCurrency = $this->storeManager->getStore()->getBaseCurrency()->getCode();
            $shipPrice = $this->currencyConvert(
                $shipPrice , $transactionList['currency_iso_code']
            );

            $responce = [
                'error_msg' => $errorMsg,
                'invalid_order' => $invalidOrder,
                'firstname' => $firstname,
                'lastname' => $lastname,
                'ship_price' => $shipPrice,
                'buyer_email' => $buyerEmail,
                'total_tax' => $totalTax
            ];
            return $responce;
        } catch (\Exception $e) {
            $this->logger->critical('getOrderItemList : '.$e->getMessage());
            return ['error_msg' => $errorMsg.'<br />'.$e->getMessage(), 'invalid_order' => true];
        }
    }

    /**
     * Get count of imported items.
     *
     * @param string $itemType
     * @return int
     */
    public function getTotalImporedCount($itemType)
    {
        $totalCount = $this->importedTmpProduct->create()->getCollection()->addFieldToFilter('item_type', ['eq' => $itemType])
                                                    ->addFieldToFilter('error', ['null' => true]);
        return count($totalCount);
    }

        /**
     * Create Imported Hipercalzado Order On Your Store.
     *
     * @param array $orderData
     * @param bool $inventoryProcess
     * @return array
     */
    public function createMageOrder($orderData, $inventoryProcess = true)
    {
        try {
            if (!$orderData['shipping_address']['street'] || !$orderData['shipping_address']['country_id']) {
                return ['error' => 1,'msg' => __('order id ').$orderData['hipercalzado_order_id'].__(' not contain address')];
            }
            $storeId = $this->storeManager->getStore()->getId();
            $store = $this->storeManager->getStore($storeId);

            $websiteId = $this->storeManager->getStore($storeId)->getWebsiteId();
            $customer = $this->customerFactory->create();
            $customer->setWebsiteId($websiteId);
            $customer->loadByEmail($orderData['email']);
            if (!$customer->getEntityId()) {
                $customer->setWebsiteId($websiteId)
                        ->setStore($store)
                        ->setFirstname($orderData['shipping_address']['firstname'])
                        ->setLastname($orderData['shipping_address']['lastname'])
                        ->setEmail($orderData['email'])
                        ->setPassword($orderData['email']);
                $customer->save();
            }

            $cartId = $this->cartManagementInterface->createEmptyCart();
            $quote = $this->cartRepositoryInterface->get($cartId);
            $quote->setStore($store);
            if(!empty($orderData['currency_iso_code'])){
                $currency =  $this->currencyFactory->create()->load($orderData['currency_iso_code']);
                $currency ? $this->storeManager->getStore($storeId)->setCurrentCurrency($currency) : "" ;
            }
            $customer = $this->customerRepository->getById($customer->getEntityId());
            $quote->assignCustomer($customer);
            $productSkus = [];
            foreach ($orderData['items'] as $item) {
                /** $product = $this->product->load($item['product_id']);*/
                $item['currency_iso_code'] = $orderData['currency_iso_code'];
                $pro = $this->saveSimpleProduct($item);
                if(!isset($pro['product_id'])){$this->logger->info('check prod: '.json_encode($pro));}
                if (!$inventoryProcess) {
                    $stockItem = $this->stockRegistry->getStockItem($pro['product_id']);
                    $qty = (int)$stockItem->getQty() + (int)$item['quantity'];
                    $stockItem->setData('is_in_stock', 1);
                    $stockItem->setData('qty', $qty);
                    $stockItem->setData('manage_stock', 1);
                    $stockItem->setData('use_config_notify_stock_qty', 1);
                    $stockItem->save();        
                }
                $product = $this->productRepository->getById($pro['product_id']);
                $price = $this->currencyConvert(
                    $item['price'] , $orderData['currency_iso_code']
                );
                $product->setPrice($price);
                $product->setSpecialPrice(null);
               
                try {
                    $quote->addProduct($product, (int)$item['quantity']);
                } catch (\Exception $e) {
                    $this->logger->critical('createMageOrder Quote addProduct: '.$e->getMessage());
                    return [
                        'error' => 1,
                        'msg' => __($e->getMessage())
                    ];
                }
                array_push($productSkus , $product->getSku());  
            }
            // Set Address to quote
            $quote->getBillingAddress()->addData($orderData['shipping_address']);
            $quote->getShippingAddress()->addData($orderData['shipping_address']);
            $carrier = $this->scopeConfig->getValue('hipercalzado/general_settings/hipercalzado_carrier');
            if(empty($carrier)){
              $carrier = 'wk_hipercalzadoconnector_ship_wk_hipercalzadoconnector_ship';
            }
            // Collect Rates and Set Shipping & Payment Method
            $this->shippingRate->setCode($carrier)->getPrice(1);
            //store shipping data in session
            
            $this->backendSession->setHipercalzadoShipDetail($orderData['shipping_service']);
            $totalTax = [
                'total_tax' => $orderData['total_tax'],
                'base_total_tax' => $this->currencyConvert(
                    $orderData['total_tax'] , $orderData['currency_iso_code']
                ),
            ]; 
            $this->backendSession->setHipercalzadoTotalTaxAmount($totalTax);
            $shippingAddress = $quote->getShippingAddress();
            $shippingAddress->setCollectShippingRates(true)
                            ->collectShippingRates()
                            ->setShippingMethod($carrier);
            $quote->getShippingAddress()->addShippingRate($this->shippingRate);
            $quote->setPaymentMethod('hipercalzado');
            $quote->setInventoryProcessed($inventoryProcess);
            // Set Sales Order Payment
            $quote->getPayment()->importData(['method' => 'hipercalzado']);
            $quote->save();
            // Collect Totals & Save Quote
            $quote->collectTotals();
            // Create Order From Quote
            $quote = $this->cartRepositoryInterface->get($quote->getId());
            $orderId = $this->cartManagementInterface->placeOrder($quote->getId());
            $order = $this->order->load($orderId);
            $importOrder = $this->scopeConfig->getValue('hipercalzado/general_settings/hipercalzado_order_default');
            $order->setState($importOrder, true);
            $order->setStatus($importOrder);
            $order->addStatusToHistory($order->getStatus(), 'Order '.$importOrder.' successfully with reference');

            // $hipercalzadoDefaultSettings = $this->getHipercalzadoDefaultSettings();
            $order->setCreatedAt($orderData['created_at']);
            $order->save();
            $order->setEmailSent(0);
            $incrementId = $order->getRealOrderId();
            // Resource Clean-Up
            $quote = $customer = $service = null;
            if ($order->getEntityId()) {
                $result['order_id'] = $order->getRealOrderId();
                $this->deleteReservationsBySkus->execute($productSkus); 
            } else {
                $result = [
                    'error' => 1,
                    'msg' => __('order id ').$orderData['hipercalzado_order_id'].__(' not created on your store')
                ];
            }
            return $result;
        } catch (\Exception $e) {
            $result = ['error' => 1, 'msg' => $e->getMessage()];
            $this->logger->critical('createMageOrder : '.$e->getMessage());
            return $result;
        }
    }

    /**
     * Check for Valid Sku to Upload Product.
     *
     * @param string $sku
     * @return array
     */
    public function isValidSku($sku)
    {
        try {
            $validate = ['valid' => true, 'product_id'=> false];
            if ($sku == '') {
                $validate['valid'] = false;
            } else {
                $product = $this->product->getIdBySku($sku);
                if ($product) {
                    $validate['valid'] = false;
                    $validate['product_id'] = $product;
                } else {
                    $validate['valid'] = true;
                }
            }
            return $validate;
        } catch (\Exception $e) {
            $this->logger->critical('isValidSku : '.$e->getMessage());
            return $validate;
        }
    }

    /**
     * Save Simple Product.
     *
     * @param Object $proDataReq
     * @param boolean $isAssociateProduct = 0
     * @param array $attributeValues = []
     * @param array $assocatedPro = []
     * @return array
     */
    public function saveSimpleProduct($proData)
    {
        $result = ['error' => 0];
        $hasWeight = 1;
        $categoryIds = [];
        $errorMsg = '';
        $storeId = $this->storeManager->getStore()->getId();
        $websiteId = $this->storeManager->getStore($storeId)->getWebsiteId();
        $sku = $proData['product_sku'];
        $validate = $this->isValidSku($sku);
        if ($validate['valid']) {
            $wholeData = [
                'form_key' => $this->formkey->getFormKey(),
                'type' => 'simple'
            ];
            $wholeData['product']['website_ids'] = explode(',', $websiteId);
            $wholeData['product']['name'] = $proData['product_title'];
            $wholeData['product']['sku'] = $proData['product_sku'];
            $wholeData['product']['type_id'] = 'simple';
            $price = $this->currencyConvert(
                $proData['price'] , $proData['currency_iso_code']
            );
            $wholeData['product']['price'] = $price;
            $wholeData['product']['tax_class_id'] = 0;
            $wholeData['product']['quantity_and_stock_status']['qty'] = isset($proData['quantity']) ?
                                                                                 $proData['quantity'] : 1;
            $wholeData['product']['quantity_and_stock_status']['is_in_stock'] = 1;
            // $wholeData['product']['product_has_weight'] = $proData['weight'] ? true : false;
            $wholeData['product']['weight'] = 1;
            // $wholeData['product']['category_ids'] = $proData['category'];
            // $wholeData['product']['description'] = $proData['description'];
            $wholeData['product']['status'] = 1;
            $wholeData['product']['visibility'] = 4;
            $wholeData['product']['attribute_set_id'] = $this->product->getDefaultAttributeSetId();
            $wholeData['product']['stock_data']['manage_stock'] = 1;
            $wholeData['product']['stock_data']['use_config_manage_stock'] = 1;
            $wholeData['product']['stock_data']['qty'] = isset($proData['quantity']) ? $proData['quantity'] : 1;

           try{
                $productId = (int) $this->saveProductData($wholeData, $proData);
                if ($productId && isset($proData['product_medias']) && !empty($proData['product_medias'])) {
                    $imageData = [];
                    foreach ($proData['product_medias'] as $key => $image) {
                        $isDefault = $key===0 ? 1 : 0;
                        $this->addImages($productId, $image['media_url'], $isDefault);
                    }
                }
            } catch (\Execption $e) {
                $this->logger->critical('saveSimpleProduct '.$e->getMessage());
                $errorMsg = $e->getMessage();
                $productId = 0;
            }

            $result = $productId ? ['error' => 0, 'product_id' => $productId]:
                  [
                      'error' => 1,
                      'error_list' => [__('Skipped %1. error in importing product. %2', $proData['product_title'], $errorMsg)]
                  ];
        } else {
            $product = $this->productRepository->getById($validate['product_id']);
            $this->saveProductMapData($proData,$product);
            $result = $validate['product_id'] ? ['error' => 0, 'product_id' => $validate['product_id']] :
                [
                    'error' => 1,
                    'product_id' => '',
                    'error_list' => [__('Product : %1. sku : %2 already exist.', $proData['product_title'], $proData['product_sku'])]
                ];
        }
        return $result;
    }

        /**
     * Add Images To Product.
     *
     * @param int $productId
     * @param string $image
     * @param int $isDefault
     */
    public function addImages($productId, $image, $isDefault)
    {
        $product = $this->productRepository->getById($productId, true, 0);
        $image = trim($image);
        if ($image != '') {
            $imgPath = $this->_getNewImagePath($image, $product->getSku());
            $this->saveImage($image, $imgPath);
            if ($this->fileSystemDriver->isExists($imgPath) && filesize($imgPath) > 0) {
                $imgValues = $isDefault ? ['image', 'small_image', 'thumbnail']: ['image'];
                if (function_exists('exif_imagetype')) {
                    $isPicture = exif_imagetype($imgPath) ? true : false;
                    if ($isPicture) {
                        $product->addImageToMediaGallery(
                            $imgPath,
                            $imgValues,
                            false,
                            false
                        );
                        $product->save();
                    }
                } else {
                    $product->addImageToMediaGallery(
                        $imgPath,
                        $imgValues,
                        false,
                        false
                    );
                    $product->save();
                }

                // $this->logger->info('saveImage prod data 3: '.json_encode($product->getData()));
                $this->fileSystemDriver->deleteFile($imgPath);
                
            }
        }
      
        return true;
    }

        /**
     * Save image in store.
     *
     * @param string $inPath
     * @param string $outPath
     */
    public function saveImage($inPath, $outPath)
    {
        try {
            $browserStr = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) AppleWebKit/525.13 '
                                    .'(KHTML, like Gecko) Chrome/0.A.B.C Safari/525.13';
            $this->curl->setOption(CURLOPT_USERAGENT, $browserStr);
            $this->curl->setOption(CURLOPT_RETURNTRANSFER, 1);
            $this->curl->setOption(CURLOPT_SSL_VERIFYHOST, 0);
            $this->curl->setOption(CURLOPT_SSL_VERIFYPEER, 0);
            $this->curl->get($inPath);
            $response = $this->curl->getBody();
            $file = $this->fileSystemDriver->fileOpen($outPath, 'w');
            if ($file === false) {
                $this->logger->info('saveImage : unable to open file');
                $this->fileSystemDriver->deleteFile($outPath);
                return false;
            }
            $this->fileSystemDriver->fileWrite($file, $response);
            $this->fileSystemDriver->fileClose($file);
            return true;
        } catch (\Exception $e) {
            $this->logger->info('saveImage : '.$e->getMessage());
            return false;
        }
    }

    /**
     * Get NewImagePath
     *
     * @param string $imageUrl
     * @param string $productSku
     * @return string
     */
    private function _getNewImagePath($imageUrl, $productSku)
    {
        $path = $this->directoryList->getPath('pub');
        $path = $path.'/media/import/hipercalzado/';
        $this->ioFile->checkAndCreateFolder($path, 0755);

        $path = $this->filesystem->getDirectoryRead(DirectoryList::MEDIA)
                                ->getAbsolutePath().'import/hipercalzado/';
        $imgSrcExplode = explode('?', $imageUrl);
        $imgSrcExplode = explode('/', $imgSrcExplode[0]);
        $imageType = substr(strrchr($imgSrcExplode[count($imgSrcExplode) - 1], '.'), 1);
        $imgPath = $path.$this->random->getRandomString(25).'.'.strtolower($imageType);
        return $imgPath;
    }

    /**
     * Default customer account page.
     *
     * @param \Magento\Framework\App\Request\Http $proDataReq
     * @param int $storeId
     * @return int
     */
    public function saveProductData($proDataReq, $proData, $storeId = 0)
    {
        try {
            $this->emulation->startEnvironmentEmulation(0, 'adminhtml');
            $req = $this->request->setPostValue($proDataReq);            
            $product = $this->initializationHelper->initialize($this->productBuilder->build($req, $storeId));
            if (!$product->getEntityId()) {
                $name = $product->getName();
                $url = preg_replace('#[^0-9a-z]+#i', '-', $name);
                $url = strtolower($url);
                $url = $url . '-' . rand(1,999);
                $product->setUrlKey($url);
            }

            $product->save();
            $productId = $product->getId();
            $this->saveProductMapData($proData,$product);
            $this->registry->unregister('product');
            $this->registry->unregister('current_product');
            $this->registry->unregister('current_store');
                      
        } catch (\Exception $e) {
            $this->logger->critical('saveProductData helper :'.$e->getMessage());
            $productId =  0;
        }
        $this->emulation->stopEnvironmentEmulation();
        return $productId;
    }

    /**
     * Save Product Map Data
     *
     * @param \Magento\Framework\App\Request\Http $proDataReq
     * @param int $storeId
     * @return int
     */
    public function saveProductMapData($proDataReq,$product){
        if ($product->getId() !== null) {
            $syncProMap = $this->productmapFactory->create()->getCollection()
                                    ->addFieldToFilter('hipercalzado_pro_id', $proDataReq['order_line_id']);
                                    $this->logger->critical('saveProductData syncProMapgetSiz : '.json_encode($syncProMap->getSize()));
            if (!$syncProMap->getSize()) {
            
                $data = [
                    'hipercalzado_pro_id' => $proDataReq['order_line_id'],
                    'hipercalzado_sku' => $proDataReq['product_sku'],
                    'sku' => $product->getSku(),
                    'magento_pro_id' =>  $product->getId(),
                    'name' => $proDataReq['product_title'],
                    'price' => $proDataReq['price'],
                    'product_type' => 'simple',
                ];
                    $this->productMapRecord->setData($data);
                    $this->productMapRecord->save();
            }
        }
    }

}
