<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */

namespace Webkul\Hipercalzado\Controller\Tokencheck;

use Magento\Framework\Controller\ResultFactory;

class Index extends \Magento\Framework\App\Action\Action
{

    public const BASE_URL = 'https://www.menuweb.es/seller/api/';
    public const TEST_BASE_URL = 'https://test.menuweb.es/seller/api/';
    public const METHOD_ORDERS = 'orders';

    /**
     * @var \Magento\Framework\App\Action\Contex
     */
    private $context;

    /**
     * @var \Magento\Framework\HTTP\Client\Curl
     */
    private $curl;

    /**
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Magento\Framework\HTTP\Client\Curl $curl
     * @param Helper $helper
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Framework\HTTP\Client\Curl $curl,
        \Webkul\Hipercalzado\Logger\Logger $logger,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
    ) {
        parent::__construct($context);
        $this->context = $context;
        $this->curl = $curl;
        $this->logger = $logger;
        $this->jsonHelper = $jsonHelper;
    }
    
    /**
     * @return json
     */
    public function execute()
    {
        $param = $this->context->getRequest()->getParams();
        $data = $this->authorizeKey($param['key']);
        $resultJson = $this->resultFactory->create(ResultFactory::TYPE_JSON);
        $resultJson->setData($data);
        return $resultJson;
    }

    /**
     * Authorize key 
     *
     * @param array $key
     * @return array
     */
    public function authorizeKey($key)
    {
        try {
            $url = self::TEST_BASE_URL . self::METHOD_ORDERS . '?max=1';

            $this->curl->addHeader("Content-Type", 'application/json');
            $this->curl->addHeader("Authorization", $key);

            $arr = [
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            ];
            $this->curl->setOptions($arr);
            $this->curl->get($url);
            if ($this->curl->getStatus() != 200) {
                return ['status'=>false, 'msg'=> $this->jsonHelper->jsonDecode($this->curl->getBody())[0]["message"]];
            } elseif ($this->curl->getStatus() == 200) {
                $data['msg'] = __('Verified Token');
                $data['status'] = true;
                return $data;
            }
        } catch (\Exception $e) {
             $this->logger->critical("Hipercalzado authorizeKey :".$e->getMessage());
            return [
                'status'=>false,
                'msg'=>__('Please try again and check the log.')
            ];
        }
    }
}