<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\Hipercalzado\Controller\Adminhtml\Product;

use Magento\Framework\Controller\ResultFactory;
use Magento\Backend\App\Action\Context;
use Webkul\Hipercalzado\Api\ProductmapRepositoryInterface;
use Magento\Catalog\Model\ResourceModel\Product\CollectionFactory;

class MassDelete extends \Magento\Backend\App\Action
{
    /**
     * @var string
     */
    public const ADMIN_RESOURCE = 'Webkul_Hipercalzado::product';
    /**
     * @var ProductmapRepositoryInterface
     */
    private $productMapRepository;

    /**
     * @param Context                       $context
     * @param ProductmapRepositoryInterface $productMapRepositoryInterface
     */
    public function __construct(
        Context $context,
        ProductmapRepositoryInterface $productMapRepository,
        CollectionFactory $productCollectionFactory
    ) {
        $this->productMapRepository = $productMapRepository;
        $this->_productCollectionFactory = $productCollectionFactory;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Backend\Model\View\Result\Redirect
     */
    public function execute()
    {
        $params = $this->getRequest()->getParams();
        $productEntityIds = $params['selected'];
        if (!is_array($productEntityIds)) {
            $productEntityIds = explode(',', $productEntityIds);
        }
        $collection = $this->productMapRepository
                    ->getCollectionByIds($productEntityIds);
        $productMapCount = 0;
        $deletedIdsArr = [];
        foreach ($collection as $productMap) {
            array_push($deletedIdsArr, $productMap->getId());
            $productMap->delete();
            ++$productMapCount;
        }
        
        $this->messageManager->addSuccess(
            __("A total of %1 record(s) have been deleted.", $productMapCount)
        );

        return $this->resultFactory->create(
            ResultFactory::TYPE_REDIRECT
        )->setPath('*/hipercalzado/index');
    }

}
