<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\Hipercalzado\Controller\Adminhtml\Order;

use Magento\Framework\Controller\ResultFactory;
use Magento\Backend\App\Action\Context;
use Magento\Ui\Component\MassAction\Filter;
use Webkul\Hipercalzado\Model\ResourceModel\Ordermap\CollectionFactory;

class MassDelete extends \Magento\Backend\App\Action
{
    /**
     * @var string
     */
    public const ADMIN_RESOURCE = 'Webkul_Hipercalzado::order';

    /**
     * Massactions filter.
     *
     * @var Filter
     */
    private $filter;

    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @param Context $context
     * @param Filter $filter
     * @param CollectionFactory $collectionFactory
     */
    public function __construct(
        Context $context,
        Filter $filter,
        CollectionFactory $collectionFactory
    ) {
        $this->filter = $filter;
        $this->collectionFactory = $collectionFactory;
        parent::__construct($context);
    }

    /**
     * Execute
     *
     * @return \Magento\Backend\Model\View\Result\Redirect
     */
    public function execute()
    {
        $collection = $this->filter->getCollection($this->collectionFactory->create());
        $orderDeleted = 0;
        foreach ($collection->getItems() as $orderMap) {
            $this->deleteOrderMap($orderMap);
            ++$orderDeleted;
        }
        $this->messageManager->addSuccess(__('A total of %1 record(s) have been deleted.', $orderDeleted));
        return $this->resultFactory->create(ResultFactory::TYPE_REDIRECT)->setPath('*/*/index');
    }

    /**
     * DeleteOrderMap
     *
     * @param Webkul\Hipercalzado\Model\Ordermap $orderMapRecord
     * @return void
     */
    private function deleteOrderMap($orderMapRecord)
    {
        $orderMapRecord->delete();
    }
}
