<?php
/**
 * Webkul Hipercalzado Order Map Controller.
 *
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\Hipercalzado\Controller\Adminhtml\Order;

use Magento\Backend\App\Action\Context;
use Magento\Framework\Json\Helper\Data as JsonHelper;
use Webkul\Hipercalzado\Logger\Logger;
use Webkul\Hipercalzado\Helper\Data as dataHelper;

class Import extends \Magento\Backend\App\Action
{
    /**
     * @var string
     */
    public const ADMIN_RESOURCE = 'Webkul_Hipercalzado::order';

    /**
     * @var \Magento\Framework\Json\Helper\Data
     */
    private $jsonHelper;

    /**
     * @var \Webkul\Hipercalzado\Helper\Data
     */
    private $dataHelper;

    /**
     * @var \Webkul\Hipercalzado\Logger\Logger
     */
    private $logger;

    /**
     * @param Context $context
     * @param JsonHelper $jsonHelper
     * @param dataHelper $dataHelper
     * @param Logger $logger
     */
    public function __construct(
        Context $context,
        JsonHelper $jsonHelper,
        dataHelper $dataHelper,
        Logger $logger
    ) {
        parent::__construct($context);
        $this->jsonHelper = $jsonHelper;
        $this->dataHelper = $dataHelper;
        $this->logger = $logger;
    }

    /**
     * hipercalzado order import controller.
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        try {
            $results = $this->dataHelper->getOrders();
            $validateData = $this->validateRequest($results);
            if ($validateData['valid_request']) {
                $items = 0;
                $notifications = ['items' => '', 'errorMsg' => ''];
                $responce = [];
                $errorMsg = '<br/>';
                $tmpWholeData = [];
                $pagenumber = $validateData['page'];
                if (isset($results['orders']['orders'])) {
                    $hipercalzadoOrders = $results['orders']['orders'];
                    $hipercalzadoOrders = isset($hipercalzadoOrders[0]) ? $hipercalzadoOrders : [0 => $hipercalzadoOrders];
                    $notifications = $this->dataHelper->manageOrderRawData($hipercalzadoOrders);
                    $items = $items + count($notifications['items']);
                    $responce = [
                        'data' => $items,
                        'error_msg' => false,
                        'total_order' => $notifications['items'],
                        'total_imported' => $results['orders']['total_count'] == 50 ? false : true,
                        'notification' => $notifications['errorMsg'],
                        'totalPage' => $results['orders']['total_count']
                    ];
                } else {
                    $responce = ['data' => '','error_msg' =>  __('No orders to import')];
                }
            } else {
                $responce = ['data' => '','error_msg' => $validateData['error_msg']];
            }
        } catch (\Exception $e) {
            $responce = ['data' => $notifications['items'],'error_msg' => $e->getMessage()];
            $this->logger->addError('Hipercalzadoorder Import'.$e->getMessage());
        }
        $this->getResponse()->representJson($this->jsonHelper->jsonEncode($responce));
    }

    /**
     * ValidateRequest
     *
     * @return array
     */
    private function validateRequest($results)
    {
        try {
            if ($this->getRequest()->isPost()) {
                if ($results['status']) {
                    $postData = $this->getRequest()->getPost();
                    $responce = [
                        'valid_request' => 1,
                        'page' => $postData['page'],
                    ];
                } else {
                    $responce = ['valid_request' => 0, 'error_msg' => __($results['msg'])];
                }
            } else {
                $responce = ['valid_request' => 0,'error_msg' => 'invalid request'];
            }
            return $responce;
        } catch (\Exception $e) {
            $this->logger->addError('Hipercalzadoorder Import'.$e->getMessage());
            return ['valid_request' => 0,'error_msg' => $e->getMessage()];
        }
    }
}
