<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\Hipercalzado\Controller\Adminhtml\Order;

use Magento\Backend\App\Action\Context;
use Magento\Framework\Json\Helper\Data as JsonHelperData;

class Createorder extends \Magento\Backend\App\Action
{
    /**
     * @var string
     */
    public const ADMIN_RESOURCE = 'Webkul_Hipercalzado::order';

    /**
     * @var \Magento\Framework\Json\Helper\Data
     */
    private $jsonHelper;

    /**
     * @var \Webkul\Hipercalzado\Model\Importedtmpproduct
     */
    private $importedtmporder;

    /**
     * @var \Webkul\Hipercalzado\Model\Ordermap
     */
    private $orderMapRecord;

    /**
     * @var \Webkul\Hipercalzado\Helper\Data
     */
    private $helperData;

    /**
     * @param Context $context
     * @param JsonHelperData $jsonHelperData
     * @param \Webkul\Hipercalzado\Model\Importedtmpproduct $importedtmporder
     * @param \Webkul\Hipercalzado\Model\Ordermap $orderMapRecord
     * @param \Webkul\Hipercalzado\Helper\Data $helperData
     */
    public function __construct(
        Context $context,
        JsonHelperData $jsonHelperData,
        \Webkul\Hipercalzado\Model\Importedtmpproduct $importedtmporder,
        \Webkul\Hipercalzado\Model\Ordermap $orderMapRecord,
        \Webkul\Hipercalzado\Helper\Data $helperData
    ) {
        parent::__construct($context);
        $this->JsonHelper = $jsonHelperData;
        $this->importedtmporder = $importedtmporder;
        $this->orderMapRecord = $orderMapRecord;
        $this->helperData = $helperData;
    }

    /**
     * Execute
     *
     * @return \Magento\Backend\Model\View\Result\Page
     */
    public function execute()
    {
        try {
            if ($this->getRequest()->isPost()) {
                $tempData = $this->importedtmporder->getCollection()
                                   ->addFieldToFilter('item_type', ['eq' => 'order'])
                                   ->addFieldToFilter('error', ['null' => true])
                                   ->setPageSize(1)->getFirstItem();
                if ($tempData->getEntityId()) {
                    $tempOrder = $this->JsonHelper->jsonDecode($tempData->getProductData());
                    $mapedOrder = $this->orderMapRecord->getCollection()
                                        ->addFieldToFilter(
                                            'hipercalzado_order_id',
                                            ['eq' => $tempOrder['hipercalzado_order_id']]
                                        )->setPageSize(1)->getFirstItem();
                    if (!$mapedOrder->getEntityId()) {
                        //Create order in stor as hipercalzado
                        $result = $this->helperData->createMageOrder($tempOrder);
                        if (isset($result['order_id']) && $result['order_id']) {
                            $data = [
                                'hipercalzado_order_id' => $tempOrder['hipercalzado_order_id'],
                                'mage_order_id' => $result['order_id'],
                                'status' => $tempOrder['order_status'],
                                'temp_data' => $tempData->getProductData()
                            ];
                            $record = $this->orderMapRecord;
                            $record->setData($data)->save();
                            $tempData->delete();
                        } else {
                            $tempData->setError($this->JsonHelper->jsonEncode($result));
                            $tempData->save();
                        }
                    } else {
                        $result = [
                            'error' => 1,
                            'msg' => __('hipercalzado order ').$tempOrder['hipercalzado_order_id']
                                    .__(' already mapped with store order #')
                                    .$mapedOrder->getMageOrderId()
                        ];
                        $tempData->delete();
                    }
                } else {
                    $data = $this->getRequest()->getParams();
                    $skip = isset($data['skip']) ? $data['skip'] : 0;
                    $total = (int) $data['count'] - (int) $skip;
                    $msg = '<div class="wk-mu-success wk-mu-box">'
                            .__('Total ').$total.__(' Order(s) Imported.').'</div>';
                    $msg .= '<div class="wk-mu-note wk-mu-box">'.__('Finished Execution.').'</div>';
                    $result['msg'] = $msg;
                }
            } else {
                $result = ['error' => 1, 'msg' => __('invalid request')];
            }
        } catch (\Execption $e) {
            $result = ['error' => 1, 'msg' => $e->getMessage()];
        }
        $this->getResponse()->representJson($this->JsonHelper->jsonEncode($result));
    }
}
