<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\Hipercalzado\Block\Adminhtml\Order;

class Profiler extends \Magento\Framework\View\Element\Template
{
    /**
     * @var \Webkul\Hipercalzado\Helper\Data
     */
    private $helperData;

    /**
     * @param \Magento\Backend\Block\Widget\Context $context
     * @param \Webkul\Hipercalzado\Helper\Data $helperData
     * @param array $data = []
     */
    public function __construct(
        \Magento\Backend\Block\Widget\Context $context,
        \Webkul\Hipercalzado\Helper\Data $helperData,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->helperData = $helperData;
        $this->jsonHelper = $jsonHelper;
    }

    /**
     * For get total imported order count.
     *
     * @return int
     */
    public function getImportedOrder()
    {
        return $this->helperData->getTotalImporedCount('order');
    }

    /**
     * For get JsonDataForProfiler.
     *
     * @return int
     */
    public function getDataForProfiler()
    {
        $orderCount = $this->getImportedOrder();
        $data = [
            "cretaeOrderUrl" => $this->getUrl('hipercalzado/order/createorder'),
            "total" => $orderCount
        ];
        $jsonEncodedData = $this->jsonHelper->jsonEncode($data);
        return ['order_count' => $orderCount, 'json_data' => $jsonEncodedData];
    }
}
