<?php
/**
 * @category   Webkul
 * @package    Webkul_hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\hipercalzado\Block\Adminhtml\Order;

class OrderMapAction extends \Magento\Backend\Block\Widget\Container
{
    /**
     * Prepare button.
     *
     * @return \Magento\Catalog\Block\Adminhtml\Product
     */
    protected function _prepareLayout()
    {
        $addButtonProps = [
            'id' => 'sync_from_hipercalzado',
            'label' => __('Sync From hipercalzado'),
            'class' => 'add',
            'button_class' => '',
            'class_name' => \Magento\Backend\Block\Widget\Button\SplitButton::class,
            'options' => $this->_gethipercalzadoSyncButtonOptions(),
        ];
        $this->buttonList->add('add_new', $addButtonProps);

        return parent::_prepareLayout();
    }

    /**
     * Retrieve options for 'Sync Product' split button.
     *
     * @return array
     */
    private function _gethipercalzadoSyncButtonOptions()
    {
        $splitButtonOptions = [
                'import_order_from_hipercalzado' => [
                                'label' => __('Import Order From hipercalzado'),
                                'id' => 'import_order_from_hipercalzado',
                            ],
                'profiler_for_create_order' => [
                                'label' => __('Run hipercalzado Order Profiler'),
                                'id' => 'profiler_for_create_order',
                            ],
            ];
        return $splitButtonOptions;
    }
}
