<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\Hipercalzado\Block\Adminhtml\Order;

class ImportScript extends \Magento\Framework\View\Element\Template
{
    /**
     * @var \Magento\Framework\Json\Helper\Data
     */
    private $jsonHelper;

    /**
     * @var \Magento\Framework\Stdlib\DateTime\TimezoneInterface
     */
    private $dateTimezone;

    /**
     * @param \Magento\Backend\Block\Widget\Context $context
     * @param \Magento\Framework\Json\Helper\Data $jsonHelper
     * @param \Magento\Framework\Stdlib\DateTime\TimezoneInterface $dateTimezone
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Widget\Context $context,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $dateTimezone,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->jsonHelper = $jsonHelper;
        $this->dateTimezone = $dateTimezone;
    }

    /**
     * GetImportScriptJsonData
     *
     * @return jsonString
     */
    public function getImportScriptJsonData()
    {
        $releventData = [
            'importAjaxUrl'    => $this->getUrl('*/*/import'),
            'profilerAjaxUrl' => $this->getUrl('hipercalzado/order/profiler'),
            'date_format' => $this->dateTimezone->getDateFormat()
        ];
        return $this->jsonHelper->jsonEncode($releventData);
    }
}
