<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\Hipercalzado\Api;

/**
 * @api
 */
interface ProductmapRepositoryInterface
{
    /**
     * Get Hipercalzado sync  collection of product by Hipercalzado rule id
     *
     * @param int $ruleId
     * @return object
     */
    public function getCollectionByRuleId($ruleId);

    /**
     * Get collection by Hipercalzado product id
     *
     * @param  int $hipercalzadoProductId
     * @return object
     */
    public function getRecordByHipercalzadoProductId($hipercalzadoProductId);

    /**
     * Get record by magento product id
     *
     * @param  int $mageProductId
     * @return object
     */
    public function getRecordByMageProductId($mageProductId);

    /**
     * Get collection by entity ids
     *
     * @param  array $entityIds
     * @return object
     */
    public function getCollectionByIds(array $entityIds);
}
