<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Hipercalzado
 * @author Webkul
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */

namespace Webkul\Hipercalzado\Api;

/**
 * Hipercalzado OrdermapRepository Interface
 */
interface OrdermapRepositoryInterface
{
    /**
     * Get by id
     *
     * @param int $id
     * @return \Webkul\Hipercalzado\Model\Ordermap
     */
    public function getById($id);
    /**
     * Save
     *
     * @param \Webkul\Hipercalzado\Model\Ordermap $subject
     * @return \Webkul\Hipercalzado\Model\Ordermap
     */
    public function save(\Webkul\Hipercalzado\Model\Ordermap $subject);
    /**
     * Get list
     *
     * @param Magento\Framework\Api\SearchCriteriaInterface $creteria
     * @return Magento\Framework\Api\SearchResults
     */
    public function getList(\Magento\Framework\Api\SearchCriteriaInterface $creteria);
    /**
     * Delete
     *
     * @param \Webkul\Hipercalzado\Model\Ordermap $subject
     * @return boolean
     */
    public function delete(\Webkul\Hipercalzado\Model\Ordermap $subject);
    /**
     * Delete by id
     *
     * @param int $id
     * @return boolean
     */
    public function deleteById($id);
}
