<?php
/**
 * @category   Webkul
 * @package    Webkul_Hipercalzado
 * @author     Webkul Software Private Limited
 * @copyright  Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license    https://store.webkul.com/license.html
 */
namespace Webkul\Hipercalzado\Api\Data;

interface ProductmapInterface
{
    /**
     * Constants for keys of data array.
     * Identical to the name of the getter in snake case.
     */
    const ID = 'entity_id';
    const HIPERCALZADO_PRO_ID = 'hipercalzado_pro_id';
    const HIPERCALZADO_SKU = 'hipercalzado_sku';
    const SKU = 'sku';
    const NAME = 'name';
    const PRICE = 'price';
    const PRODUCT_TYPE = 'product_type';
    const MAGENTO_PRO_ID = 'magento_pro_id';
    const MAGE_CAT_ID = 'mage_cat_id';
    const CHANGE_STATUS = 'change_status';
    const CREATED_AT = 'created';
    const RULE_ID = "rule_id";

    /**
     * Get ID.
     *
     * @return int|null
     */
    public function getId();

    /**
     * Set ID.
     *
     * @param int $id
     * @return $this
     */
    public function setId($id);

    /**
     * Get HipercalzadoProId.
     *
     * @return string
     */
    public function getHipercalzadoProId();

    /**
     * Set HipercalzadoProId.
     *
     * @param string $hipercalzadoProId
     * @return $this
     */
    public function setHipercalzadoProId($hipercalzadoProId);

    /**
     * Get Name.
     *
     * @return string
     */
    public function getName();

    /**
     * Set Name.
     *
     * @param string $name
     * @return $this
     */
    public function setName($name);

    /**
     * Get ProductType.
     *
     * @return string
     */
    public function getProductType();

    /**
     * Set ProductType.
     *
     * @param string $productType
     * @return $this
     */
    public function setProductType($productType);

    /**
     * Get MagentoProId.
     *
     * @return string
     */
    public function getMagentoProId();

    /**
     * Set MagentoProId.
     *
     * @param int $magentoProId
     * @return $this
     */
    public function setMagentoProId($magentoProId);

    /**
     * Get MageCatId.
     *
     * @return string
     */
    public function getMageCatId();

    /**
     * Set MageCatId.
     *
     * @param int $mageCatId
     * @return $this
     */
    public function setMageCatId($mageCatId);

    /**
     * Get ChangeStatus.
     *
     * @return string
     */
    public function getChangeStatus();

    /**
     * Set ChangeStatus.
     *
     * @param int $changeStatus
     * @return $this
     */
    public function setChangeStatus($changeStatus);

    /**
     * Get CreatedAt.
     *
     * @return string
     */
    public function getCreatedAt();

    /**
     * Set CreatedAt.
     *
     * @param string $created
     * @return $this
     */
    public function setCreatedAt($created);

    /**
     * Get rule id.
     *
     * @return int
     */
    public function getRuleId();

    /**
     * Set rule id.
     *
     * @param int $ruleId
     */
    public function setRuleId($ruleId);

    /**
     * Get Price
     *
     * @return int
     */
    public function getPrice();

    /**
     * Set Price
     *
     * @param int $price
     */
    public function setPrice($price);

    /**
     * Get HipercalzadoSku
     *
     * @return int
     */
    public function getHipercalzadoSku();

    /**
     * Set HipercalzadoSku
     *
     * @param int $sku
     */
    public function setHipercalzadoSku($sku);

        /**
     * Get Sku
     *
     * @return int
     */
    public function getSku();

    /**
     * Set Sku
     *
     * @param int $sku
     */
    public function setSku($sku);
}
