<?php
/**
 * Webkul Software.
 *
 * @category Webkul
 * @package Webkul_Hipercalzado
 * @copyright Copyright (c) Webkul Software Private Limited (https://webkul.com)
 * @license https://store.webkul.com/license.html
 */

namespace Webkul\Hipercalzado\Api\Data;

/**
 * Hipercalzado Ordermap Interface
 */
interface OrdermapInterface
{

    public const ENTITY_ID = 'entity_id';

    public const HIPERCALZADO_ORDER_ID = 'hipercalzado_order_id';

    public const MAGE_ORDER_ID = 'mage_order_id';

    public const STATUS = 'status';

    public const CREATED_AT = 'created_at';

    /**
     * Set EntityId
     *
     * @param int $entityId
     * @return Webkul\Hipercalzado\Api\Data\OrdermapInterface
     */
    public function setEntityId($entityId);
    /**
     * Get EntityId
     *
     * @return int
     */
    public function getEntityId();
    /**
     * Set HipercalzadoOrderId
     *
     * @param string $hipercalzadoOrderId
     * @return Webkul\Hipercalzado\Api\Data\OrdermapInterface
     */
    public function setHipercalzadoOrderId($hipercalzadoOrderId);
    /**
     * Get HipercalzadoOrderId
     *
     * @return string
     */
    public function getHipercalzadoOrderId();
    /**
     * Set MageOrderId
     *
     * @param string $mageOrderId
     * @return Webkul\Hipercalzado\Api\Data\OrdermapInterface
     */
    public function setMageOrderId($mageOrderId);
    /**
     * Get MageOrderId
     *
     * @return string
     */
    public function getMageOrderId();
    /**
     * Set Status
     *
     * @param string $status
     * @return Webkul\Hipercalzado\Api\Data\OrdermapInterface
     */
    public function setStatus($status);
    /**
     * Get Status
     *
     * @return string
     */
    public function getStatus();
    /**
     * Set CreatedAt
     *
     * @param string $createdAt
     * @return Webkul\Hipercalzado\Api\Data\OrdermapInterface
     */
    public function setCreatedAt($createdAt);
    /**
     * Get CreatedAt
     *
     * @return string
     */
    public function getCreatedAt();
}
